import edge_tts
import asyncio
import os
import logging

# 配置日志记录器，将日志信息输出到alarm.log文件中，记录级别为INFO，日志格式为时间-日志级别-消息
logging.basicConfig(filename='alarm.log', level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')

# 存储已播报过的报警文本，防止重复播报
alarm_text_cache = set()

def convert_text_to_speech(text,audioName):
    # 检查文本是否已经播报过，如果已经播报过则跳过，避免重复播报
    if text in alarm_text_cache:
        logging.info(f"文本已播报过: {text}")
        return

    async def my_function():
        tts = edge_tts.Communicate(text=text,)
        await tts.save(audioName)
        # 播报完成后将文本添加到缓存中，避免重复播报
        alarm_text_cache.add(text)
        # 记录日志，表明已播报的文本
        logging.info(f"已播报文本: {text}")
    
    asyncio.run(my_function())

if __name__ == "__main__":
    convert_text_to_speech("sample Test","demo.mp3")