from configure import ip_table
def parse_bacnetName(point_name,point_ip):
    try:
        if point_ip in ip_table:
            zone=ip_table[point_ip]
            name=point_name
            tags={
                "zone":zone,
                "name":name,
                "prefix":"",
                "zoneTag":zone,
            }
            return tags
        else:
            zone=point_name.split("/")[1].split(".")[1]
            zoneTag=point_name.split("/")[1].split(".")[1]
            name=point_name.split("/")[1].split(".")[2]
            
            if "X_K" in zone:
                zone=zone.replace("X_K","新工房空调机组K")
                prefix=point_name.split("X_K")[0]
            if "X_X" in zone:
                zone=zone.replace("X_X","新风机组X")
                prefix=point_name.split("X_X")[0]
            tags={
                "zone":zone,
                "name":name,
                "prefix":prefix,
            }
            return tags
    except IndexError:
            print(f"设备名称格式错误：{point_name} 解析失败")
            tags={
                "zone":"zone",
                "name":"name",
                "prefix":"prefix",
                "zoneTag":"zoneTag",
            }
            return tags




def generate_audio_name(point_name):
    try:
        audio_part = point_name.split("K", 1)[1]
        return f"K{audio_part}.mp3"
    except IndexError:
        print(f"设备名称格式错误：{point_name} 缺少K标识符")
        return point_name + ".mp3"