from re import A
from peewee import *
from models import db, Point
from configure import *
from voice import convert_text_to_speech
from tools import *
import time
import threading




alarms = {}

def generate_alert_message(point,alarm_item):
    try:
        message=point.zone+alarm_item['Text']
        convert_text_to_speech(message, message+".mp3")
        return message  
    except Exception as e:
        print(f"语音报警失败：{str(e)}")






def check_Range(point, alarm_item):
    """
    Check if the value of a point is out of the specified range.
    If so, print the value and name of the point.

    :param point_name: The name of the point to check.
    :param low_limit: The lower limit of the acceptable range.
    :param high_limit: The upper limit of the acceptable range.
    """
    if point.value < alarm_item["LowLimit"] or point.value > alarm_item["HighLimit"]:
            generate_alert_message(point, alarm_item)


def check_Deta(point1, point2,alarm_item):
    """
    Check if the value of a point is out of the specified range.
    If so, print the value and name of the point.

    :param point_name: The name of the point to check.
    :param low_limit: The lower limit of the acceptable range.
    :param high_limit: The upper limit of the acceptable range.
    """
    try:
        deta = abs(point1.value - point2.value2)
        if deta < alarm_item["DetaT"]:
            generate_alert_message(point1, alarm_item)
       
    except Point.DoesNotExist:
        print(f"Point {point1.name} does not exist.")
    
#FAU AHU

#新风或者空调机组开了
runningPoints=[point for point in Point.select().where(Point.name.contains("AHU_SF_S")) if point.value in ["on", "active", "开", "开机","开启"]]+[point for point in Point.select().where(Point.name.contains("FAU_S")) if point.value in ["on", "active", "开", "开机","开启"]]
for point in runningPoints:
    point.




    


